% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_gibbs_steps.R
\name{post_regression}
\alias{post_regression}
\title{Draws the parameters in a regression equation with AR errors, if specified.}
\usage{
post_regression(
  Y,
  X,
  beta = NULL,
  betaDistr,
  sigma,
  sigmaDistr,
  phi = NULL,
  phiDistr = NULL,
  indep = TRUE,
  const = NULL,
  constDistr = NULL
)
}
\arguments{
\item{Y}{dependent variable}

\item{X}{explanatory variable(s)}

\item{beta}{coefficient vector}

\item{betaDistr}{prior distribution of coefficient vector}

\item{sigma}{innovation variance}

\item{sigmaDistr}{prior distribution of innovation variance}

\item{phi}{autoregressive coefficient vector}

\item{phiDistr}{prior distribution of autoregressive coefficient vector}

\item{indep}{logical, should beta and sigma be independent}

\item{const}{constant}

\item{constDistr}{prior distribution of constant}
}
\value{
A named vector of drawn parameters.
}
\description{
Draws the parameters in a regression equation with AR errors, if specified.
}
\details{
See "Chib, Siddhartha. "Bayes regression with autoregressive
errors: A Gibbs sampling approach." Journal of econometrics 58.3 (1993):
275-294."
}
\keyword{internal}
