% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eb_times.r
\name{get_eb_times_segmag_diff}
\alias{get_eb_times_segmag_diff}
\title{Retrieve event boundary times for a difference of segmag objects}
\usage{
get_eb_times_segmag_diff(segmag, segmag_substract, cutoff_max = NULL,
  cutoff_min = NULL)
}
\arguments{
\item{segmag}{object of class \code{\link{segmag}}}

\item{segmag_substract}{object of class \code{\link{segmag}}.}

\item{cutoff_max}{numeric value determining the critical cutoff for maxima in
segmentation magnitude}

\item{cutoff_min}{numeric value determining the critical cutoff for minima in
segmentation magnitude}
}
\value{
numeric vector with event boundary times. If cutoff_max or cutoff_min is
        NULL than the respective event boundaries are omitted.
}
\description{
Specific function when calculating event boundaries for the difference of
two segmag objects (segmag - segmag_substract). Returns the times of event
boundaries that are defined as the center of local maxima (minima) in
segmentation magnitude that are higher (lower) than a critical cutoff max/min values.
The critical cutoff max/min values should be determined with the
\code{\link{bootstrap_critical_cutoffs}} function.
}
\seealso{
\code{\link{get_eb_times}}, \code{\link{bootstrap_critical_cutoffs}}
}

