% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{segmentCluster.batch}
\alias{segmentCluster.batch}
\title{Batch wrapper for \code{\link{segmentClusters}}.}
\usage{
segmentCluster.batch(cset, varySettings = setVarySettings(),
  fuse.threshold = 0.2, rm.nui = TRUE, type.name, short.name = TRUE,
  id, save.matrix = FALSE, verb = 1)
}
\arguments{
\item{cset}{a clustering set as returned by \code{\link{clusterTimeseries}}}

\item{varySettings}{list of settings where each entry can be a vector;
the function will construct a matrix of all possible combinations of
parameter values in this list, call \code{\link{segmentClusters}} for
each, and report a matrix of segments where the segment `type' is
constructed from the varied parameters; see option \code{short.name}.
A varySettings list with all required (default) parameters can be
obtained via function \code{\link{setVarySettings}}.}

\item{fuse.threshold}{if adjacent segments are associated with clusters
the centers of which have a Pearson correlation \code{>fuse.threshold}
the field "fuse" will be set to 1 for the second segments (top-to-bottom
as reported)}

\item{rm.nui}{remove nuisance cluster segments from final results}

\item{type.name}{vector of strings selecting the parameters which will be
used as segment types. Note, that all parameters that are actually varied
will be automatically added (if missing). The list can include parameters
from time-series processing found in the "clustering" object \code{cset}
as \code{cset$tids}.}

\item{short.name}{default type name construction; if TRUE (default)
parameters that are not varied will not be part of the segment type and ID.
This argument has no effect if argument \code{type.name} is set.}

\item{id}{if set, the default segment IDs, constructed from numbered
segment types, are replaced by this}

\item{save.matrix}{store the total score matrix \code{S(i,c)} and the
backtracing matrix \code{K(i,c)}; useful in testing stage or for
debugging or illustration of the algorithm;
TODO: save.matrix is currently not implemented, since batch function
returns a matrix only}

\item{verb}{level of verbosity, 0: no output, 1: progress messages}
}
\value{
Returns an object of class "segments", just as its base function
\code{\link{segmentClusters}}, but the main segment table, list item
"segments", is a \code{\link[base:data.frame]{data.frame}} with additional
columns "ID" and "type", automatically generated strings indicating
the used parameters (each "type" reflects one parameter set), and
"colors", indicating the automatically generated color of the assigned
cluster label.
}
\description{
A high-level wrapper for multiple runs of segmentation by
\code{\link{segmentClusters}} for multiple clusterings and/or
multiple segmentation parameters. It additionally allows to
tag adjacent segments to be potentially fused due to similarity
of their clusters.
}
\details{
This is a high-level wrapper for \code{\link{segmentClusters}}
which allows segmentation over multiple clusterings as provided by the
function \code{\link{clusterTimeseries}} and over multiple segmentation
parameters. Each parameter in the list \code{varySettings} can be
a vector and ALL combinations of the passed parameter values will
be used for one run of \code{\link{segmentClusters}}.
The resulting segment table, list item "segments" of the returned object,
is a \code{\link[base:data.frame]{data.frame}} with additional
columns "ID" and "type", automatically generated strings indicating
the used parameters (each "type" reflects one parameter set), and
"colors", indicating the automatically generated color of the assigned
cluster label.
}
\examples{
# load example data, an RNA-seq time-series data from a short genomic
# region of budding yeast
data(primseg436)

# 1) Fourier-transform time series:
tset <- processTimeseries(ts=tsd, na2zero=TRUE, use.fft=TRUE,
                          dft.range=1:7, dc.trafo="ash", use.snr=TRUE)

# 2) cluster time-series several times into K=12 clusters:
cset <- clusterTimeseries(tset, K=c(12,12,12))

# 3) choose parameter ranges, here only E is varied 
vary <- setVarySettings(M=100, E=c(1,3), nui=3, S="icor", Mn=20)

# 4) ... segment ALL using the batch function:
\dontrun{ ## NOTE: takes too long for CRAN example timing restrictions
segments <- segmentCluster.batch(cset=cset, varySettings=vary)

# 5) inspect results:
print(segments)
plotSegmentation(tset, cset, segments)

# 6) and get segment border table. Note that the table has
#    additional columns "ID" and "type", indicating the used parameters,
#    and "color" providing the color of the cluster the segment was
#    assigned to. This allows to track segments in the inspection plots.
sgtable <- segments$segments
}

}
