% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overall.R
\name{otest_g}
\alias{otest_g}
\title{Jointly tests for segregation distortion and number of incompatible genotypes}
\usage{
otest_g(
  x,
  g1,
  g2,
  pbad = 0.03,
  drbound = 1/6,
  pp = TRUE,
  dr = TRUE,
  alpha = 0,
  xi1 = 1/3,
  xi2 = 1/3
)
}
\arguments{
\item{x}{A vector of genotype counts. \code{x[i]} is the number of
offspring with genotype \code{i-1}.}

\item{g1}{The genotype of parent 1.}

\item{g2}{The genotype of parent 2.}

\item{pbad}{The upper bound on the number of bad genotypes}

\item{drbound}{The maximum rate of double reduction. A default of 1/6
is provided, which is the rate under the complete equational
segregation model of meiosis.}

\item{pp}{A logical. Should we account for preferential pairing
(\code{TRUE}) or not (\code{FALSE})?}

\item{dr}{A logical. Should we account for double reduction
(\code{TRUE}) or not (\code{FALSE})?}

\item{alpha}{If \code{dr = FALSE}, this is the known rate of double
reduction.}

\item{xi1}{If \code{pp = FALSE}, this is the known preferential pairing
parameter of parent 1.}

\item{xi2}{If \code{pp = FALSE}, this is the known preferential pairing
parameter of parent 2.}
}
\value{
A list with the following elements
\describe{
\item{\code{statistic}}{The log-likelihood ratio test statistic.}
\item{\code{df}}{The degrees of freedom.}
\item{\code{p_value}}{The Bonferroni corrected p-value.}
\item{\code{p_lrt}}{The p-value of the LRT.}
\item{\code{p_binom}}{The p-value of the one-sided binomial test.}
\item{\code{alpha}}{The estimated double reduction rate.}
\item{\code{xi1}}{The estimated preferential pairing parameter of parent 1.}
\item{\code{xi2}}{The estimated preferential pairing parameter of parent 2.}
}
}
\description{
This is experimental. I haven't tested it out in lots of scenarios yet.
}
\details{
Here, we test if the compatible genotypes are consistent with F1 populations
and separately test that the number of incompatible genotypes isn't too
large (less than 3 percent by default). This is the strategy the
polymapR software uses. But we use a Bonferroni correction to combine
these tests (minimum of two times the p-values), while they just multiply
the p-values together. So our approach accounts for double reduction and
preferential pairing, while also controlling the family-wise error rate.
}
\examples{
# Run a test where genotypes 0, 1, and 2 are possible
x <- c(10, 10, 4, 0, 5)
otest_g(x = x, g1 = 1, g2 = 0)

# polymapR's multiplication and the Bonferroni differ
df <- expand.grid(p1 = seq(0, 1, length.out = 20), p2 = seq(0, 1, length.out = 20))
df$polymapr <- NA
df$bonferroni <- NA
for (i in seq_len(nrow(df))) {
  df$polymapr[[i]] <- df$p1[[i]] * df$p2[[i]]
  df$bonferroni[[i]] <- 2 * min(c(df$p1[[i]], df$p2[[i]], 0.5))
}
graphics::plot(df$polymapr, df$bonferroni)


}
\author{
David Gerard
}
