% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_readHTMLTable.R
\name{safe_readHTMLTable}
\alias{safe_readHTMLTable}
\title{Safe html table scrapping}
\usage{
safe_readHTMLTable(..., time = 60, attempts = 10)
}
\arguments{
\item{...}{arguments that will be passed to readHTMLTable}

\item{time}{sleep interval after each failure}

\item{attempts}{max number of tries (if there is a problem with connection)}
}
\value{
character vector
}
\description{
Function \code{safe_readHTMLTable} tries to download the table from given URL several times.
}
\details{
Function \code{safe_readHTMLTable} performes 10 (by default) attempts to download the URL
and waits 60sec (by default) after each failure
}
\examples{
\dontrun{
page <- paste0('http://www.sejm.gov.pl/Sejm7.nsf/',
               'posiedzenie.xsp?posiedzenie=99&dzien=2')
safe_readHTMLTable(page)}

}
\author{
Przemyslaw Biecek
}

