% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pars_id.R
\name{pars_id_to_lorg}
\alias{pars_id_to_lorg}
\title{Ids to "lhs-op-rhs-(group)"}
\usage{
pars_id_to_lorg(pars_id, pars_source, type = c("free", "all"))
}
\arguments{
\item{pars_id}{A vector of integers. Usually the output
of \link{pars_id}.}

\item{pars_source}{Can be the output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} or \code{\link[lavaan:parTable]{lavaan::parameterTable()}},
or a named vector of free parameters (e.g., the output
of \code{\link[=coef]{coef()}} applied to a \code{lavaan}-class object).}

\item{type}{The meaning of the values in \code{pars_id}.
If \code{"free"}, they
are the position in the vector of free parameters (i.e.,
the output of of \code{coef()}). If "all", they are the
row numbers in the parameter table (the output of
\code{\link[lavaan:parTable]{lavaan::parameterTable()}}). If \code{pars_source}
is the output of \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}, which
does not indicate whether a parameter is free or fixed,
this argument will be ignored.}
}
\value{
If \code{pars_source} is the output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} or
\code{\link[lavaan:parTable]{lavaan::parameterTable()}}, it returns a subset of
\code{pars_source}, keeping the rows of selected parameters
and the columns \code{lhs}, \code{op}, \code{rhs}, and \code{group}. If
\code{pars_source} is a named vector of free parameters, it
returns a character vector containing the names of the
selected parameters.
}
\description{
Converts id numbers generated by \code{\link[=pars_id]{pars_id()}}
to values that can be used to extract the parameters
from a source.
}
\details{
If the source is a parameter estimates table (i.e.,
the output of \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}, it returns
a data frame with columns "lhs", "op", and "rhs". If
"group" is present in the source, it also add a column
"group". These columns can be used to uniquely identify
the parameters specified by the ids.

If the source is a named vector of parameters (e.g., the
output of \code{\link[=coef]{coef()}}), it returns the names of parameters
based on the ids.
}
\examples{
dat <- sem_dat
set.seed(64264)
library(lavaan)
sem_model <-
"
f1 =~  x1 + x2 + x3
f2 =~  x4 + x5 + x6
f3 =~  x7 + x8 + x9
f2 ~   f1
f3 ~   f2
"
fit_ng <- sem(sem_model, dat)

pars <- c("f1 =~ x2", "f2 =~ x5", "f2 ~ f1")
tmp <- pars_id(pars, fit = fit_ng)
pars_id_to_lorg(tmp, pars_source = coef(fit_ng))
tmp <- pars_id(pars, fit = fit_ng, where = "partable")
pars_id_to_lorg(tmp, pars_source = parameterEstimates(fit_ng))

# Multiple-group models

dat$gp <- sample(c("Alpha", "Beta", "Gamma"),
                 nrow(dat),
                 replace = TRUE)

fit_gp <- sem(sem_model, dat, group = "gp")

pars <- c("f1 =~ x2", "f2 =~ c(NA, 1, NA) * x5")
tmp <- pars_id(pars, fit = fit_gp)
pars_id_to_lorg(tmp, pars_source = coef(fit_gp))
tmp <- pars_id(pars, fit = fit_gp, where = "partable")
pars_id_to_lorg(tmp, pars_source = parameterEstimates(fit_gp))

parameterTable(fit_gp)[tmp, ]
pars2 <- c("f1 =~ x2", "~~.Beta", "f2 =~ x5.Gamma")
tmp <- pars_id(pars2, fit = fit_gp)
pars_id_to_lorg(tmp, pars_source = coef(fit_gp))
tmp <- pars_id(pars2, fit = fit_gp, where = "partable")
pars_id_to_lorg(tmp, pars_source = parameterEstimates(fit_gp))
# Note that group 1 is "Beta", not "Alpha"
lavInspect(fit_gp, "group.label")

}
