% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_options.R
\name{show_options}
\alias{show_options}
\alias{print.show_options}
\title{Show Major Options in an
Output of 'lavaan'}
\usage{
show_options(fit)

\method{print}{show_options}(x, ...)
}
\arguments{
\item{fit}{An output of
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers
(e.g., \code{\link[lavaan:cfa]{lavaan::cfa()}} and
\code{\link[lavaan:sem]{lavaan::sem()}})}

\item{x}{The output of \code{\link[=show_options]{show_options()}}.}

\item{...}{Additional arguments. Ignored.}
}
\value{
A \code{show_options}-class object with a
print method that formats the output.
}
\description{
Display the values of
major options in a model fitted
by \code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its
wrappers (e.g., \code{\link[lavaan:sem]{lavaan::sem()}} or
\code{\link[lavaan:cfa]{lavaan::cfa()}}).
}
\details{
It extracts the values of
major options in the output of
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers
(e.g., \code{\link[lavaan:sem]{lavaan::sem()}} or
\code{\link[lavaan:cfa]{lavaan::cfa()}}.

It checks the actual values, not
the call used. This is useful for
understanding how a prepackaged
estimator such as \code{ML}, \code{MLM}, and
\code{MLR} set other options. It
supports the following options:
\itemize{
\item Estimator (\code{estimator})
\item Standard error (\code{se})
\item Model chi-square test(s) (\code{test})
\item Missing data method (\code{missing})
\item Information matrix used for
computing standard errors
(\code{information})
\item Information matrix used for
computing model chi-square
(\code{information})
\item Whether the mean structure is
included.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(show_options)}: The print method of the output of \code{\link[=show_options]{show_options()}}.

}}
\examples{
library(lavaan)

# From the help page of lavaan::cfa().

HS.model <- '
visual  =~ x1 + x2 + x3
textual =~ x4 + x5 + x6
speed   =~ x7 + x8 + x9
'
fit <- cfa(HS.model, data = HolzingerSwineford1939)

tmp <- show_options(fit)
tmp

fit <- cfa(HS.model, data = HolzingerSwineford1939, estimator = "MLR")
show_options(fit)
fit <- cfa(HS.model, data = HolzingerSwineford1939, estimator = "MLM")
show_options(fit)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
