% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSubjSex.R
\name{getSubjSex}
\alias{getSubjSex}
\title{Extract the set of animals of the specified sex - or just add the sex of each
animal.}
\usage{
getSubjSex(
  dbToken,
  animalList,
  sexFilter = NULL,
  inclUncertain = FALSE,
  noFilterReportUncertain = TRUE
)
}
\arguments{
\item{dbToken}{Mandatory\cr
Token for the open database connection (see \code{\link{initEnvironment}}).}

\item{animalList}{Mandatory, data.table.\cr
A table with the list of animals to process.\cr
The table must include at least columns named 'STUDYID' and 'USUBJID'.}

\item{sexFilter}{Optional, character.\cr
The sex value criterion to be used for filtering of the list of animals.\cr
It can be a single string, a vector or a list of multiple strings.}

\item{inclUncertain}{Mandatory, boolean.\cr
Indicates whether animals for which the sex cannot be confidently identified
shall be included or not in the output data table.}

\item{noFilterReportUncertain}{Mandatory, boolean.\cr
Only relevant if the \code{sexFilter} is empty.\cr
Indicates if the reason should be included if the sex cannot be confidently
decided for an animal.}
}
\value{
The function returns a data.table with columns:
\itemize{
\item STUDYID       (character)
\item Additional columns contained in the \code{animalList} table
\item SEX          (character)
\item UNCERTAIN_MSG (character)\cr
Included when parameter \code{inclUncertain=TRUE}.\cr
In case the sex cannot be confidently matched during the filtering of data,
the column contains an indication of the reason.\cr
Is NA for rows where SEX can be confidently matched.\cr
A non-empty UNCERTAIN_MSG value generated by this function is merged with
non-empty UNCERTAIN_MSG values which may exist in the input set of animals
specified in \code{animalList} - separated by '|'.
\item NOT_VALID_MSG (character)\cr
Included when parameter \code{noFilterReportUncertain=TRUE}.\cr
In case the sex cannot be confidently decided, the column contains an
indication of the reason.\cr
Is NA for rows where sex can be confidently decided.\cr
A non-empty NOT_VALID_MSG value generated by this function is merged with
non-empty NOT_VALID_MSG values which may exist in the input set of animals
\code{animalList} - separated by '|'.
}
}
\description{
Returns a data table with the set of animals included in the
\code{animalList} of the sex specified in the \code{sexFilter}.\cr
If the \code{sexFilter} is empty (null, na or empty string) - all rows from
\code{animalList} are returned with the an additional populated SEX column.
}
\details{
The sex value is decided from the DM.SEX variable.\cr
The comparison of DM.SEX with the given value(s) in \code{sexFilter} is done
case-insensitive.

If input parameter \code{inclUncertain=TRUE}, uncertain animals are included
in the output set. These uncertain situations are identified and reported (in
column UNCERTAIN_MSG):
\itemize{
\item The DM.SEX value is empty or invalid (not CT value - CDISC codelist
SEX - case insensitive comparison)
}
The same checks are performed and reported in column NOT_VALID_MSG if
\code{sexFilter} is empty and \code{noFilterReportUncertain=TRUE}.
}
\examples{
\dontrun{
getSubjSex(myDbToken, controlAnimals, 'M')
}
}
