% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_publisher_portfolio.R
\name{st_publisher_portfolio}
\alias{st_publisher_portfolio}
\title{Publisher Portfolio Analysis}
\usage{
st_publisher_portfolio(
  publisher = NULL,
  publisher_id = NULL,
  start_date = "2023-01-01",
  end_date = NULL,
  countries = "WW",
  metrics = c("revenue", "downloads", "mau"),
  include_rankings = TRUE,
  include_portfolio_total = TRUE,
  granularity = "yearly",
  min_revenue = 1e+05,
  auth_token = Sys.getenv("SENSORTOWER_AUTH_TOKEN"),
  verbose = TRUE,
  use_cache = FALSE,
  cache_dir = NULL
)
}
\arguments{
\item{publisher}{Character. Publisher name to search for (e.g., "Lilith Games",
"Supercell", "King"). The function will search for the publisher and use
the first match.}

\item{publisher_id}{Character. Optional. If provided, skips the publisher
search and uses this unified_publisher_id directly.}

\item{start_date}{Date or character. Start date for metrics (default: "2023-01-01").}

\item{end_date}{Date or character. End date for metrics (default: last day of
previous month).}

\item{countries}{Character. Countries for metrics (default: "WW" for worldwide).}

\item{metrics}{Character vector. Which metrics to fetch. Options: "revenue",
"downloads", "mau". Default: all three.}

\item{include_rankings}{Logical. Whether to fetch subgenre rankings from top
charts. Default: TRUE.}

\item{include_portfolio_total}{Logical. Whether to add a portfolio total row.
Default: TRUE.}

\item{granularity}{Character. How to aggregate the data: "yearly" (default),
"quarterly", or "monthly".}

\item{min_revenue}{Numeric. Minimum revenue threshold to include an app.
Default: 100000 (apps with at least $100K in any year).}

\item{auth_token}{Character. Sensor Tower API token. Defaults to
SENSORTOWER_AUTH_TOKEN environment variable}

\item{verbose}{Logical. Print progress messages. Default: TRUE.}

\item{use_cache}{Logical. Use cached data if available. Default: FALSE.
When TRUE, requires cache_dir to be specified.}

\item{cache_dir}{Character. Directory for cached data. Default: NULL (no caching).
Must be explicitly set to enable caching. Use tempdir() for temporary caching.}
}
\value{
A tibble with portfolio data including:
  - app_name: Game name
  - subgenre: Game sub-genre
  - subgenre_rank: Rank within sub-genre
  - revenue_\{year\}: Revenue by year
  - downloads_\{year\}: Downloads by year
  - mau_\{year\}: Average MAU by year (if requested)
  - revenue_yoy, downloads_yoy, mau_yoy: Year-over-year growth percentages
}
\description{
Fetches comprehensive portfolio data for a publisher including revenue,
downloads, MAU, and rankings. Returns a tidy data frame ready for
visualization or GT table creation.
}
\examples{
\dontrun{
# Simple usage - just provide publisher name
lilith_portfolio <- st_publisher_portfolio("Lilith Games")

# Piped workflow
library(dplyr)

"Supercell" \%>\%
  st_publisher_portfolio(
    start_date = "2023-01-01",
    metrics = c("revenue", "downloads")
  ) \%>\%
  filter(revenue_2024 > 1000000) \%>\%
  arrange(desc(revenue_2024))

# Custom date range and countries
portfolio <- st_publisher_portfolio(
  publisher = "King",
  start_date = "2022-01-01",
  end_date = "2024-12-31",
  countries = c("US", "GB", "DE"),
  metrics = c("revenue", "downloads", "mau"),
  include_rankings = TRUE
)
}

}
