% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_and_install.R
\name{install_scoring_model}
\alias{install_scoring_model}
\title{Install a Scoring Model}
\usage{
install_scoring_model(
  model = c("en.large", "en", "multi.large", "multi"),
  scoring = c("xgb", "glm"),
  scoring_version = "1.0",
  ...
)
}
\arguments{
\item{model}{The embedding model, one of c("en.large", "en", "multi.large",
"multi").}

\item{scoring}{The scoring model, currently one of:
\itemize{
\item "xgb" does default xgboost
\item "glm" does generalized linear model (if you can't run xgboost)
}}

\item{scoring_version}{Version of scoring model (will add more over time)}

\item{...}{Additional options to the function, including:
\itemize{
\item repo_url: OPTIONAL custom github repo blob url for external scoring models.
The default repo_url is "https://github.com/BenWiseman/sentiment.ai/blob/main/models"
}}
}
\value{
0 if model did not need to be downloaded.
1 if model needed to be downloaded.
}
\description{
Install a Scoring Model
}
\details{
This downloads the scoring models from a set repository in order to keep the
main package within CRAN size limits.

In the future, this will also make it possible for the community to add new
and improved models!
}
