% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_envelope.R
\name{applyEnvelope}
\alias{applyEnvelope}
\title{Apply an envelope}
\usage{
applyEnvelope(sample, env)
}
\arguments{
\item{sample}{Sound sample object.}

\item{env}{Envelope object. Envelope values should all be between 0 and 1.}
}
\value{
A sound sample object.
}
\description{
Apply a volume envelope to a sound sample.
}
\examples{
# Define the sound sample
sam <- soundSample(sin(2*pi*seq(0,0.5,1/44100)*220)) # 0.5-second A (220 Hz)
# Define the envelope
env <- envelope(t=c(0,0.03,1),v=c(0,1,0))
# Apply it
res <- applyEnvelope(sam,env)
# Compare waveforms
plot(sam,main='before')
plot(res,main='after')
\dontrun{
# This line of code is wrapped in \dontrun{} since it relies
# on an external audio player to listen to the audio sample.
# See ?tuneR::setWavPlayer for setting a default player.
listen(res)}
}
