% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPRT-methods.R
\docType{methods}
\name{show,SPRT-method}
\alias{show,SPRT-method}
\title{Displays results from a "SPRT" object nicely}
\usage{
\S4method{show}{SPRT}(object)
}
\arguments{
\item{object}{Created as a result of a call to \code{\link{sprt}}.}
}
\value{
A summary of test results or specification (if data = NA or omitted).
}
\description{
Method for signature \code{"SPRT"} to show results or test specification.
}
\examples{

test00 <- sprt(mu0 = 2,
                mu1 = 4,
                density_func = "negative binomial",
                overdispersion = 4.6,
                alpha = 0.1,
                beta = 0.1)
show(test00) # returns test specification.

counts <- c(2, 5, 6, 2, 7)

test11 <- sprt(data = counts,
                mu0 = 2,
                mu1 = 4,
                density_func = "negative binomial",
                overdispersion = 4.6,
                alpha = 0.1,
                beta = 0.1)
show(test11) # returns "accept H1" after 5 sampling bouts processed.

## End (Not run)
}
