% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgname.R
\docType{package}
\name{serial}
\alias{serial}
\title{A serial communication interface for R.}
\description{
This R package provides the functionality of serial communication ports
"COM" or "tty" to use the RS232/RS422/RS485 capabilities of the corresponding 
hardware. Also virtual COM-ports via USB do work, as long as they are mapped
to COM[n] (win) or tty[n] (Linux) in the operating system.

\describe{
 \item{\code{open(con)}}{opens a serial connection}
 \item{\code{close(con)}}{closes the serial connection}
 \item{\code{flush(con)}}{flushes the serial connection}
 \item{\code{nBytesInQueue(con)}}{get the length of pending input an output queue}
 \item{\code{read.serialConnection(con)}}{read from the interface as long as 
 the buffer is not empty}
 \item{\code{write.serialConnection(con,dat)}}{writes a data (character or binary) to the serial interface}
 \item{\code{isOpen(con)}}{test a connection, whether it is open or not}
 \item{\code{listPorts()}}{list all available ports on the system}
}
}
\examples{
# for this example I used the 'null-modem' emulator 'com0com' for Windows
# which is available on 'http://com0com.sourceforge.net/'
# Here the pair of com-ports is 'CNCA0' <-> 'CNCB0'

# Test the functionality:
# ======================
#
# first: install the virtual null-modem connection like
#        com0com (win) or tty0tty (linux)
#        Hint: Some unix insist on port names like 'ttyS[n]'.
# 
# second: setup a terminal program (like HTerm or gtkterm) and listen to 
#         com-port 'CNCB0' (or what ever you have installed)
#         or (for unix only) 'cat /dev/tnt1' will output tnt1 to console

\dontrun{

# Now configure one of the com-ports with appropriate connection properties
con <- serialConnection(name = "testcon",port = "CNCA0"
                       ,mode = "115200,n,8,1"
                       ,newline = 1
                       ,translation = "crlf"
                       )

# let's open the serial interface

open(con)

# write some stuff
write.serialConnection(con,"Hello World!")

# read, in case something came in
read.serialConnection(con)

# show summary
summary(con)

# close the connection
close(con)



# Reading and writing binary (hexadecimal) data
# remember: Everything is a string, so you might need data conversation

con <- serialConnection(name = "testcon",port = "CNCA0"
                       ,mode = "115200,n,8,1"
                       ,translation = "binary" # switches to binary data
                       )

# let's open the serial interface

open(con)

# write some stuff
write.serialConnection(con, rawToChar(as.raw(15)) ) # 0x0F
write.serialConnection(con, c(15,20) ) # 0x0F, 0x14
write.serialConnection(con, c(0x6F,0x6C) )

# read, in case something came in
# the output is always a character vector
a <- read.serialConnection(con)

# convert the character vector to hexadecimal (raw) values
print(a)

# close the connection
close(con)

}
}
\concept{RS232}
\concept{RS422}
\concept{RS485}
\concept{USB}
\concept{serial communication}
