% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_seromodel.R
\name{plot_summary}
\alias{plot_summary}
\title{Plots model summary}
\usage{
plot_summary(
  seromodel,
  serosurvey,
  loo_estimate_digits = 1,
  central_estimate_digits = 2,
  rhat_digits = 2,
  size_text = 11,
  plot_constant = FALSE
)
}
\arguments{
\item{seromodel}{stan_fit object obtained from sampling a model
with \link{fit_seromodel}}

\item{serosurvey}{\describe{
\item{\code{survey_year}}{Year in which the survey took place
(only needed to plot time models)}
\item{\code{age_min}}{Floor value of the average between age_min and age_max}
\item{\code{age_max}}{The size of the sample}
\item{\code{n_sample}}{Number of samples for each age group}
\item{\code{n_seropositive}}{Number of positive samples for each age group}
}}

\item{loo_estimate_digits}{Number of loo estimate digits}

\item{central_estimate_digits}{Number of central estimate digits}

\item{rhat_digits}{Number of rhat estimate digits}

\item{size_text}{Size of text for plotting (\code{base_size} in
\link[ggplot2:ggtheme]{ggplot2})}

\item{plot_constant}{boolean specifying whether to plot single
Force-of-Infection estimate and its corresponding rhat value instead
of showing this information in the summary.
Only relevant when \code{seromodel@model_name == "constant"})}
}
\value{
ggplot object with a summary of the specified model
}
\description{
Plots model summary
}
\examples{
\donttest{
data(veev2012)
seromodel <- fit_seromodel(veev2012, iter = 100)
plot_summary(seromodel, veev2012)
}
}
