% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hav_be_2002}
\alias{hav_be_2002}
\title{Hepatitis A serological data from Belgium in 2002 (line listing)}
\format{
A data frame with 2 variables:
\describe{
 \item{age}{Age of individual}
 \item{seropositive}{If the individual is seropositive or not}
}
}
\source{
Thiry, N., Beutels, P., Shkedy, Z. et al. The seroepidemiology
of primary varicella-zoster virus infection in Flanders (Belgium).
Eur J Pediatr 161, 588-593 (2002).
\doi{doi:10.1007/s00431-002-1053-2}
}
\usage{
hav_be_2002
}
\description{
A subset of the serological dataset of Varicella-Zoster Virus (VZV) and
Parvovirus B19 in Belgium where only individuals living in Flanders were
selected
}
\examples{
# Reproduce Fig 4.1 (upper right panel), p. 63
library(dplyr)
df <- hav_be_2002 \%>\%
  group_by(age) \%>\%
  summarise(pos = sum(seropositive), tot = n())
plot(
  df$age, df$pos / df$tot,
  pty = "s", cex = 0.06 * df$tot, pch = 16, xlab = "age",
  ylab = "seroprevalence", xlim = c(0, 86), ylim = c(0, 1)
)

}
\keyword{datasets}
