% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{transform_data}
\alias{transform_data}
\title{Generate a dataframe with `t`, `pos` and `tot` columns from
`t` and `seropositive` vectors.}
\usage{
transform_data(t, spos, heterogeneity_col = "t")
}
\arguments{
\item{t}{the time vector.}

\item{spos}{the seropositive vector.}

\item{heterogeneity_col}{new name for the time vector (default to "t")}
}
\value{
dataframe in aggregated format
}
\description{
Generate a dataframe with `t`, `pos` and `tot` columns from
`t` and `seropositive` vectors.
}
\examples{
df <- hcv_be_2006
hcv_df <- transform_data(df$dur, df$seropositive)
hcv_df

}
