% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfclust-methods.R
\name{print.sfclust}
\alias{print.sfclust}
\title{Print method for sfclust objects}
\usage{
\method{print}{sfclust}(x, ...)
}
\arguments{
\item{x}{An object of class 'sfclust'.}

\item{...}{Additional arguments passed to \code{print.default}.}
}
\value{
Invisibly returns the input \code{sfclust} object \code{x}. The function also
prints a summary of:
\itemize{
\item the within-cluster model formula,
\item clustering hyperparameters,
\item movement counts from the MCMC sampler,
\item and the log marginal likelihood of the selected sample.
}
}
\description{
Prints details of an sfclust object, including the (i) within-cluster formula;
(ii) hyperparameters used for the MCMC sample such as the number of clusters penalty
(q) and the movement probabilities (move_prob); (iii) the number of movement type dones
during the MCMC sampling; and (iv) the log marginal likelihood of the model of the last
clustering sample.
}
