% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_flip_unit.R
\name{unit_orientation}
\alias{unit_orientation}
\alias{sfc_flip_unit,sfc_nxn-method}
\alias{sfc_flip_unit}
\alias{sfc_flip_unit,sfc_unit-method}
\title{Flip units}
\usage{
unit_orientation(p, index = "")

\S4method{sfc_flip_unit}{sfc_nxn}(p, index = "", to = NULL)

\S4method{sfc_flip_unit}{sfc_unit}(p, bases)
}
\arguments{
\item{p}{The corresponding object.}

\item{index}{A string of digits representing the path on the hierarchy of the curve. The left
side corresponds to the top level and the right side corresponds to the bottom level
on the curve. For the 2x2 curve, the digits can only be 1-4, and for the Peano and
Meander curves, the digits can be 1-9. The hierarchical index should be specified in a format of \code{i1:i2:i3:...}
where \code{:} can be replaced by any non-number character. For 2x2 and 3x3 curves, \code{:} can be omitted and the
hierarchical index can be specified as \code{i1i2i3...}. See examples in \code{\link[=sfc_index]{sfc_index()}}. The value can also
be a vector where each flipping is applied in sequence.}

\item{to}{The orientation to flip to. If the specified unit already has such orientation, the function returns
the original curve.}

\item{bases}{Normally use \code{\link{BASE_LIST}}.}
}
\value{
\code{unit_orientation()} returns a string one of "vertical", "horizontal", "diagonal_1" and "diagonal_-1".

\code{sfc_flip_unit} returns an \code{sfc_nxn} object.
}
\description{
Flip units
}
\details{
The orientation of a unit is the orientation
of the line connected by the entry-corner and exit-corner of that unit.

A unit in the curve is represented as a square block (e.g. \verb{2^k x 2^k} for the 2x2 curve and \verb{3^k x 3^k} for the Peano and Meander curves, \code{k} between 1 and the level of the curve).
In the 2x2 curve, if an unit can be flipped, it is symmetric, thus flipping in the 2x2 curve does not change its form.
The flipping is mainly applied on the Peano curve and the Meander curves. Peano curve only allows flippings by the diagonals and the Meander
curve only allows flipping horizontally or vertically. The type of flipping is choosen automatically in the function.

Currently, \code{sfc_flip_unit()} only works on curves with a single base pattern as the seed.
}
\examples{
p = sfc_3x3_meander("I", 11)
draw_multiple_curves(
    p, 
    sfc_flip_unit(p, "1"), # bottom left
    sfc_flip_unit(p, "2"), # bottom middle
    sfc_flip_unit(p, "3"), # bottom right
    nrow = 2)

p = sfc_3x3_peano("I", level = 3)
draw_multiple_curves(
    p, 
    sfc_flip_unit(p, ""),
    sfc_flip_unit(p, "2"),
    sfc_flip_unit(p, "2:1"),
    nrow = 2)

p = sfc_3x3_peano("I", level = 2)
draw_multiple_curves(p, 
    sfc_flip_unit(p, c("4", "7")),
    sfc_flip_unit(p, c("1", "2", "3", "5", "6", "8", "9")),
    nrow = 1)
}
