% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_generator.R
\name{sfc_generator}
\alias{sfc_generator}
\title{Generate a nxn curve based on expansion rules}
\usage{
sfc_generator(
  rules,
  name,
  envir = topenv(parent.frame()),
  flippable = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{rules}{An \code{sfc_rules} object.}

\item{name}{Name of the curve. The name will be used for the functions that will be generated.}

\item{envir}{Environment where the functions are exported.}

\item{flippable}{Whether \code{rules} can have flipped version? If it is \code{TRUE}, the generated function also accepts the \code{flip} argument.}

\item{verbose}{Whether to print messages?}
}
\value{
No value is returned.
}
\description{
Generate a nxn curve based on expansion rules
}
\details{
Two functions will be exported:
\itemize{
\item \verb{sfc_\{name\}()}
\item \verb{draw_rules_\{name\}()}
}

For the simplicity, flipping is not supported yet.
}
\examples{
UNIVERSE_4x4_PEANO = c("I", "R", "L")

RULES_4x4_PEANO = list()
RULES_4x4_PEANO[["I"]][[1]] = sfc_unit("RIILLIIRRIILLIIR", rot = 0, universe = UNIVERSE_4x4_PEANO)
RULES_4x4_PEANO[["I"]][[2]] = sfc_hflip(RULES_4x4_PEANO[["I"]][[1]])
RULES_4x4_PEANO[["R"]][[1]] = sfc_unit("IIIRRIILLIIRRIIL", rot = 0, universe = UNIVERSE_4x4_PEANO)      
RULES_4x4_PEANO[["R"]][[2]] = sfc_rotate(sfc_unit("LIIRRIILLIIRRIII", 
                                rot = 270, universe = UNIVERSE_4x4_PEANO), 90)
RULES_4x4_PEANO[["L"]][[1]] = sfc_hflip(RULES_4x4_PEANO[["R"]][[2]])
RULES_4x4_PEANO[["L"]][[2]] = sfc_hflip(RULES_4x4_PEANO[["R"]][[1]])

SFC_RULES_4x4_PEANO = sfc_rules(rules = RULES_4x4_PEANO,
        name = "Peano 4x4",
        bases = BASE_LIST[UNIVERSE_4x4_PEANO])

sfc_generator(SFC_RULES_4x4_PEANO, "4x4_peano")
draw_rules_4x4_peano()
sfc_4x4_peano("I", 111) |> plot()
}
