% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgdGMF-class.R
\name{coefficients.sgdgmf}
\alias{coefficients.sgdgmf}
\alias{coef.sgdgmf}
\title{Extract the coefficient of a GMF model}
\usage{
\method{coefficients}{sgdgmf}(
  object,
  ...,
  type = c("all", "colreg", "rowreg", "scores", "loadings")
)

\method{coef}{sgdgmf}(object, ..., type = c("all", "colreg", "rowreg", "scores", "loadings"))
}
\arguments{
\item{object}{an object of class \code{sgdgmf}}

\item{...}{further arguments passed to or from other methods}

\item{type}{the type of coefficients which should be returned}
}
\value{
If \code{type="all"}, a list of coefficients containing the fields \code{B}, \code{A}, \code{U} and \code{V}.
Otherwise, a matrix of coefficients, corresponding to the selected \code{type}.
}
\description{
Return the estimated coefficients of a GMF model, i.e., the row- and column-specific
regression effects, the latent scores and loadings.
}
\examples{
# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 100, m = 20, ncomp = 5, family = poisson())

# Fit a GMF model with 3 latent factors
gmf = sgdgmf.fit(data$Y, ncomp = 3, family = poisson())

# Get the estimated coefficients of a GMF model
str(coefficients(gmf)) # returns all the coefficients
str(coefficients(gmf, type = "scores")) # returns only the scores, say U
str(coefficients(gmf, type = "loadings")) # returns only the loadings, say V

}
