% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgee.control.R
\name{sgee.control}
\alias{sgee.control}
\title{Auxiliary for Controlling SGEE fitting}
\usage{
sgee.control(maxIt = 200, epsilon = 0.05, stoppingThreshold = NULL,
  undoThreshold = 0.005, interceptLimit = NULL, stochastic = 1,
  sampleProb = NULL, reSample = 1, withReplacement = FALSE)
}
\arguments{
\item{maxIt}{Maximum number of iterations of the stagewise algorithm to be
executed. Default is 200.}

\item{epsilon}{Step size to be used when incrementing coefficient value(s)
in each iteration. Default is 0.05.}

\item{stoppingThreshold}{An integer value that indicates the maximum number
of allowed covariates in the model. Once the algorithm has reached the value
of \code{stoppingThreshold}, the algorithm will stop without completing any
remaining iterations. The number of covariates to be included cannot exceed
the number of observations. The default value is typically
the minimum of the number
of covariates and the number of observations, minus 1 if an intercept is
included.}

\item{undoThreshold}{A small value used to determine if consecutive
steps are sufficiently different. If consecutive steps effectively undo each
other (as indicated by having a sum with an absolute value less than
\code{undoThreshold}), then the steps are repeated and the stepsize is
reduced. A negative value for \code{undoThreshold} effectively prevents
this step. \code{undoThreshold} should only be big enough to allow for
some rounding error in steps and should be much smaller than the step size.
Default value is 0.005.}

\item{interceptLimit}{sgee functions make use of the extendInt parameter
of uniroot to estimate the intercept in each iteration. This parameter
was recently implemented and thus may cause issues with older versions of R.
If a value is given for \code{interceptLimit}, then this extendInt parameter
is bypassed and a solution for the intercept estimating equation is sought
out between negative \code{interceptLimit} and positive
\code{interceptLimit}. The default value of \code{NULL} uses the
extendInt functionality.}

\item{stochastic}{A numeric value between 0 (exclusive) and 1 (inclusive)
to indicate what proportion of the data should be subsampled
in the stochastic implementation of stagewise approached. The default value
of 1 implements the standard deterministic approach where no subsampling
is done.}

\item{sampleProb}{A user provided value dictating the
probability distribution for stochastic stagewise approaches.
\code{sampleProb} can be provided as 1) a vector of
fixed values of length equal to the resposne vector y, 2) a function
that takes in a list of values (full list of values given in details)
and returns a vector of length equal to the response vector y, or 3) the
default value of \code{NULL}, which results in a uniform distribution}

\item{reSample}{Parameter indicating how frequently a subsample is
collected in stochastic stagewise approaches. If reSample == 1 then
a subsample is collected every iteration,if reSample == 2 a subsample
is collected every two (i.e every other) iteration. If reSample == 0,
(the default value) then a subsample is only collected once
before any iterations have been done.}

\item{withReplacement}{a Logical value indicating if the subsampling in
stochastic stagewise approaches should be done with or without replacement.
Default values is \code{FALSE}.}
}
\value{
A list containing all of the parameter values.
}
\description{
Auxiliary function for \code{sgee} fitting functions. Specifies
parameters used by all \code{sgee} fitting functions in terms
of the path generation; i.e. step size \code{epsilon}, maximum number of
iterations \code{maxIt}, and the threshold for premature stopping
\code{stoppingthreshold}.
}
\author{
Gregory Vaughan
}
