\name{Truncated normal distribution}
\alias{rlse_norm}
\alias{rlre_norm}
\alias{rlhce_norm}
\alias{rlae_norm}
\title{Relative loss for various entropy measures using the truncated normal distribution}
\usage{
rlse_norm(p, alpha, beta)
rlre_norm(p, alpha, beta, delta)
rlhce_norm(p, alpha, beta, delta)
rlae_norm(p, alpha, beta, delta)
}
\description{
Compute the relative information loss of the Shannon, Rényi, Havrda and Charvat, and Arimoto entropies of the truncated normal distribution.
}

\arguments{
\item{alpha}{
The location parameter of the normal distribution (\eqn{\alpha\in\left(-\infty,+\infty\right)}).
}
\item{beta}{
The strictly positive scale parameter of the normal distribution (\eqn{\beta > 0}).
}

\item{p}{
The truncation time \eqn{(p>0)}.
}
\item{delta}{
The strictly positive parameter  (\eqn{\delta > 0}) and (\eqn{\delta \ne 1}).
}
}

\value{
The functions rlse_norm, rlre_norm, rlhce_norm, and rlae_norm provide the relative information loss based on the Shannon entropy, Rényi entropy, Havrda and Charvat entropy, and Arimoto entropy, respectively, depending on the selected parametric values of the truncated normal distribution, \eqn{p} and \eqn{\delta}.
}
\references{
Awad, A. M., & Alawneh, A. J. (1987). Application of entropy to a life-time model. IMA Journal of Mathematical Control and Information, 4(2), 143-148.

Patel, J. K., & Read, C. B. (1996). Handbook of the normal distribution (Vol. 150). CRC Press.

}

\author{
Muhammad Imran, Christophe Chesneau and Farrukh Jamal

R implementation and documentation: Muhammad Imran <imranshakoor84@yahoo.com>, Christophe Chesneau <christophe.chesneau@unicaen.fr> and Farrukh Jamal \email{farrukh.jamal@iub.edu.pk}.
}


%\note{
%%  ~~further notes~~
%}

\seealso{
\code{\link{re_norm}
}
}


\examples{
p <- c(0.25, 0.50, 0.75)
rlse_norm(p, 0.2, 1)
rlre_norm(p, 0.2, 1, 0.5)
rlhce_norm(p, 0.2, 1, 0.5)
rlae_norm(p, 0.2, 1, 0.5)
}


