% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_algorithm.R
\name{reconstruct_algorithm}
\alias{reconstruct_algorithm}
\title{reconstruct_algorithm}
\usage{
reconstruct_algorithm(
  pattern,
  method,
  n_random,
  e_threshold,
  max_runs,
  no_change,
  annealing,
  weights,
  r_length,
  r_max,
  stoyan,
  verbose,
  plot
)
}
\arguments{
\item{pattern}{ppp object with pattern.}

\item{n_random}{Integer with number of randomizations.}

\item{e_threshold}{Double with minimum energy to stop reconstruction.}

\item{max_runs}{Integer with maximum number of iterations if \code{e_threshold}
is not reached.}

\item{no_change}{Integer with number of iterations at which the reconstruction will
stop if the energy does not decrease.}

\item{annealing}{Double with probability to keep relocated point even if energy
did not decrease.}

\item{weights}{Vector with weights used to calculate energy.
The first number refers to Gest(r), the second number to pcf(r).}

\item{r_length}{Integer with number of intervals from \code{r = 0} to \code{r = rmax} for which
the summary functions are evaluated.}

\item{r_max}{Double with maximum distance used during calculation of summary functions. If \code{NULL},
will be estimated from data.}

\item{stoyan}{Coefficient for Stoyan's bandwidth selection rule.}

\item{verbose}{Logical if progress report is printed.}

\item{plot}{Logical if pcf(r) function is plotted and updated during optimization.}
}
\value{
list
}
\description{
Pattern reconstruction (internal)
}
\keyword{internal}
