% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component.R
\name{empty_state_component}
\alias{empty_state_component}
\title{Create an empty state component}
\usage{
empty_state_component(content, title, subtitle = NULL)
}
\arguments{
\item{content}{An HTML tag object used to render and provide
the main content for the empty state.}

\item{title}{A character string representing the main text
that describes the empty state content.}

\item{subtitle}{A character string providing supporting
details about the empty state. Defaults to \code{NULL}}
}
\value{
a shiny.tag
}
\description{
Function to create a custom empty state component.
}
\details{
\code{content} works best with \code{\link[fontawesome:fa]{fontawesome::fa()}} and \code{\link[bsicons:bs_icon]{bsicons::bs_icon()}}.
\code{\link[shiny:icon]{shiny::icon()}} will also work, but this will require loading the
html dependencies in the ui, i.e. calling \code{\link[fontawesome:fa_html_dependency]{fontawesome::fa_html_dependency()}}
to use icons from FontAwesome.Glyphicon does not need any html dependency.
}
\examples{
library(shiny.emptystate)

if (interactive()) {
  empty_state_component(
    fontawesome::fa(name = "clipboard-question", height = "10rem"),
    title = "Content is not available",
    subtitle = "Please provide valid inputs to generate content."
  )

  empty_state_component(
    bsicons::bs_icon(
      name = "question-square",
      size = "15rem"
    ),
    title = "Content is not available",
    subtitle = "Please provide valid inputs to generate content."
  )
}

}
