% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twDateRangeInput.R
\name{twDateRangeInput}
\alias{twDateRangeInput}
\title{Wrapper around \code{\link[shiny:dateRangeInput]{shiny::dateRangeInput()}} but allowing for more classes}
\usage{
twDateRangeInput(
  inputId,
  label,
  start = NULL,
  end = NULL,
  min = NULL,
  max = NULL,
  format = "yyyy-mm-dd",
  startview = "month",
  weekstart = 0,
  language = "en",
  separator = " to ",
  width = NULL,
  autoclose = TRUE,
  container_class = NULL,
  label_class = NULL,
  input_class = NULL,
  sep_class = NULL,
  label_after_input = FALSE
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{start}{The initial start date. Either a Date object, or a string in
\code{yyyy-mm-dd} format. If NULL (the default), will use the current
date in the client's time zone.}

\item{end}{The initial end date. Either a Date object, or a string in
\code{yyyy-mm-dd} format. If NULL (the default), will use the current
date in the client's time zone.}

\item{min}{The minimum allowed date. Either a Date object, or a string in
\code{yyyy-mm-dd} format.}

\item{max}{The maximum allowed date. Either a Date object, or a string in
\code{yyyy-mm-dd} format.}

\item{format}{The format of the date to display in the browser. Defaults to
\code{"yyyy-mm-dd"}.}

\item{startview}{The date range shown when the input object is first clicked.
Can be "month" (the default), "year", or "decade".}

\item{weekstart}{Which day is the start of the week. Should be an integer
from 0 (Sunday) to 6 (Saturday).}

\item{language}{The language used for month and day names. Default is "en".
Other valid values include "ar", "az", "bg", "bs", "ca", "cs", "cy", "da",
"de", "el", "en-AU", "en-GB", "eo", "es", "et", "eu", "fa", "fi", "fo",
"fr-CH", "fr", "gl", "he", "hr", "hu", "hy", "id", "is", "it-CH", "it",
"ja", "ka", "kh", "kk", "ko", "kr", "lt", "lv", "me", "mk", "mn", "ms",
"nb", "nl-BE", "nl", "no", "pl", "pt-BR", "pt", "ro", "rs-latin", "rs",
"ru", "sk", "sl", "sq", "sr-latin", "sr", "sv", "sw", "th", "tr", "uk",
"vi", "zh-CN", and "zh-TW".}

\item{separator}{String to display between the start and end input boxes.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{autoclose}{Whether or not to close the datepicker immediately when a
date is selected.}

\item{container_class}{additional classes to be applied to the container}

\item{label_class}{additional classes to be applied to the label}

\item{input_class}{additional classes to be applied to the input element}

\item{sep_class}{additional classes to be applied to the separator element}

\item{label_after_input}{TRUE/FALSE if the label should be put after the
input box. Default is FALSE. Useful for special cases (floating labels),
c.f. 04-shiny-inputs example app.}
}
\value{
a list with a \code{shiny.tag} class
}
\description{
Wrapper around \code{\link[shiny:dateRangeInput]{shiny::dateRangeInput()}} but allowing for more classes
}
\examples{
shiny::dateRangeInput("date", "A Date")
twDateRangeInput(
  "date", "A Date Range",
  container_class = "CONTAINER", label_class = "LABEL",
  input_class = "INPUT", sep_class = "SEP"
)

# basic full shiny example
library(shiny)

ui <- fluidPage(
  use_tailwind(),
  twDateRangeInput(
    "date", "A Date",
    # Apply tailwind classes
    container_class = "w-48 m-4 p-2 border border-gray-200 rounded-md drop-shadow-md",
    label_class = "font-mono text-gray-600",
    input_class = "drop-shadow-lg text-gray-600 font-mono rounded-md border-amber-400",
    sep_class = "bg-amber-600 text-white font-bold font-mono"
  ),
  verbatimTextOutput("value")
)

server <- function(input, output) {
  output$value <- renderText({
    as.character(input$date)
  })
}

if (interactive()) shiny::shinyApp(ui, server)
}
\seealso{
\code{\link[shiny:dateRangeInput]{shiny::dateRangeInput()}}
}
