% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPersp.R
\name{setPersp}
\alias{setPersp}
\title{Custom perspective effect}
\usage{
setPersp(
  id = NULL,
  class = NULL,
  direction = "Y",
  angle = 45,
  depth = 600,
  side = "left",
  hover = FALSE
)
}
\arguments{
\item{id}{Use this argument if you want to target an individual element.}

\item{class}{The element to which the persp should be applied.}

\item{direction}{Perspective direction: "X" or "Y".}

\item{angle}{Rotation intensity: numeric, 45 by default.}

\item{depth}{Perspective depth: numeric, 600 by default.}

\item{side}{Perspective side: "left" or "right".}

\item{hover}{Whether to apply the persp effect on hover. FALSE by default.}
}
\description{
Allow to apply a perspective effect on a given element.
}
\examples{
 if (interactive()) {

  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)
  library(shinyEffects)

  boxTag <- box(
   id = "mybox",
   title = "A box",
   status = "warning",
   solidHeader = FALSE,
   collapsible = TRUE,
   p("Box Content")
  )

  shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(

      setPersp(id = "mybox", angle = 45),

      tags$h2("Add Perspective effects"),
      br(),
      boxTag
     ),
     controlbar = dashboardControlbar(),
     title = "DashboardPage"
   ),
   server = function(input, output) { }
  )
}
}
