% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accordion.R
\docType{data}
\name{accordionEnrollOnClick}
\alias{accordionEnrollOnClick}
\alias{activatorClass}
\title{Define Enroll/Collapse trigger}
\format{
An object of class \code{character} of length 1.
}
\usage{
accordionEnrollOnClick(prev = FALSE)

activatorClass
}
\arguments{
\item{prev}{Should the current (FALSE) or previous (TRUE) item be enrolled?
`prev = TRUE` can be useful if the last accordion item is removed and we want
to enroll the preceding item.}
}
\value{
`html` class string that can be used for defining i.e. `onclick`
  attribute callback.

Character string - class name used for identifying accordion activator object.
}
\description{
The function is useful if you want to override standard behavior for activating accordion item.
By default accordion item is activated when its header is clicked.

In order to point the trigger to a different object (included in item's header or content)
attach `onclick = accordionEnrollOnClick()` attribute to the element.
Remember to set `enroll_callback = FALSE` to turn off standard activation behavior (click action on header).

If you want the item to be disabled (like button) when the item is enrolled please also add
`class = activatorClass` to it.
}
\examples{
if (interactive()) {
  library(shiny)
  activator <- function(disabled = FALSE) {
    tags$button(
      "Enroll", class = activatorClass, onclick = accordionEnrollOnClick(),
      disabled = if (isTRUE(disabled)) NA else NULL
    )
  }
  ui <- fluidPage(
    tags$head(tags$style(
      ".acc-header, .acc-content {border: 1px solid; border-radius: 5px;}"
    )),
    accordion(
      "acc",
      accordionItem(
        "first", div("Hello", activator(TRUE)), "There",
        enroll_callback = FALSE, active = TRUE
      ),
      accordionItem(
        "second", div("General", activator(FALSE)), "Kenobi",
        enroll_callback = FALSE
      )
    )
  )
  server <- function(input, output, session) {}

  shinyApp(ui, server)
}

}
\keyword{datasets}
