% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radioMatrixInput.R
\name{radioMatrixInput}
\alias{radioMatrixInput}
\title{Create radioMatrixInput}
\usage{
radioMatrixInput(
  inputId,
  rowIDs,
  rowLLabels,
  rowRLabels = NULL,
  choices = NULL,
  selected = NULL,
  choiceNames = NULL,
  choiceValues = NULL,
  rowIDsName = "ID",
  labelsWidth = list(NULL, NULL)
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{rowIDs}{character. Vector of row identifiers that will be used to find
values that the user has selected. In the output, the component will return
a named list of values, each name corresponding to the row id, and the
value - to the value user has selected in this row.}

\item{rowLLabels}{character. Vector (or a matrix with one column) of labels that 
displayed in the leftmost point of each row. The column name of the matrix 
could be displayed in the header of the assignment matrix.}

\item{rowRLabels}{character. Vector (or a matrix with one column) of labels that 
displayed in the rightmost point of each row. The column name of the matrix 
could be displayed in the header of the assignment matrix. Using this argument 
is optional. But it allows to create Likert scales, potentially with several 
scales arranged in a matrix.}

\item{choices}{List of values to select from (if elements of the list are
named then that name rather than the value is displayed to the user). If
this argument is provided, then choiceNames and choiceValues must not be
provided, and vice-versa. The values should be strings; other types (such
as logicals and numbers) will be coerced to strings.}

\item{selected}{Vector of the initially selected values (if not specified then 
defaults to \code{NULL}).}

\item{choiceNames, choiceValues}{List of names and values, respectively, that 
are displayed to the user in the app and correspond to the each choice (for 
this reason, the objects 'choiceNames' and 'choiceValues' must have the 
same length). If either of these arguments is provided, then the other must 
be provided and choices must not be provided. The advantage of using both of 
these over a named list for choices is that the object 'choiceNames' allows 
any type of UI object to be passed through (tag objects, icons, HTML code, 
...), instead of just simple text.}

\item{rowIDsName}{single character that defines the header of the ID column in the
input matrix.}

\item{labelsWidth}{List of two valid values of CSS length unit. Each element 
has to be a properly formatted CSS unit of length (e.g., \code{'10\%'},
\code{'40px'}, \code{'auto'}), specifying the minimum (first value) and 
maximum (second value) width of the labels columns. The valid elements will 
be written to the \code{style} attribute of the labels \code{td} tags.}
}
\value{
HTML markup for radioMatrixInput
}
\description{
Create radioMatrixInput
}
\examples{
library(shiny)
library(shinyRadioMatrix)


## Only run examples in interactive R sessions
if (interactive()) {

  data(exTaxonList)
  data(exPftList)

  ui <- fluidPage(
    radioMatrixInput(inputId = "rmi01", rowIDs = head(exTaxonList$Var),
           rowLLabels = head(as.matrix(subset(exTaxonList, select = "VarName"))),
           choices = exPftList$ID,
           selected = head(exTaxonList$DefPFT)),
    verbatimTextOutput('debug01')
  )

  server <- function(input, output, session) {
    output$debug01 <- renderPrint({input$rmi01})
  }

  shinyApp(ui, server)
}

if (interactive()) {

  ui <- fluidPage(

    radioMatrixInput(inputId = "rmi02", rowIDs = c("Performance", "Statement A"),
                     rowLLabels = c("Poor", "Agree"),
                     rowRLabels = c("Excellent", "Disagree"),
                     choices = 1:5,
                     selected = rep(3, 2),
                     rowIDsName = "Grade",
                     labelsWidth = list("100px", "100px")),
    verbatimTextOutput('debug02')
  )

  server <- function(input, output, session) {
    output$debug02 <- renderPrint({input$rmi02})
  }

  shinyApp(ui, server)

}

}
