% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtain_coordinates_for_anchorpoints.R
\name{obtain_coordiantes_for_anchorpoints}
\alias{obtain_coordiantes_for_anchorpoints}
\title{Obtain coordinates for anchorpoints from GFF files}
\usage{
obtain_coordiantes_for_anchorpoints(
  anchorpoints,
  species1,
  gff_file1,
  out_file,
  species2 = NULL,
  gff_file2 = NULL
)
}
\arguments{
\item{anchorpoints}{A file containing anchorpoints information with columns like gene_x, gene_y, and other relevant data.}

\item{species1}{The name of the first species.}

\item{gff_file1}{The path to the GFF file for the first species.}

\item{out_file}{The output file where the results will be saved.}

\item{species2}{(Optional) The name of the second species. Specify this parameter and gff_file2 if working with two species.}

\item{gff_file2}{(Optional) The path to the GFF file for the second species.}
}
\value{
None. The function saves the results to the specified out_file.
}
\description{
This function takes a file containing anchorpoints, GFF files for two species, and species names,
and retrieves the coordinates of anchorpoints and associated genes from the GFF files.
}
