% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aframeTags.R
\docType{data}
\name{aframetags}
\alias{aframeAssets}
\alias{aframeBox}
\alias{aframeEntity}
\alias{aframeMixin}
\alias{aframePrimitive}
\alias{aframeScene}
\alias{aframeSphere}
\alias{aframetags}
\alias{atags}
\title{A-Frame Custom Elements}
\format{The \code{atags} list contains all of these
  tag functions for convenient access.}
\usage{
aframeScene(...)

aframeAssets(...)

aframeMixin(...)

aframeEntity(...)

aframeSphere(...)

aframeBox(...)

aframePrimitive(primitive = "entity", ...)

atags
}
\arguments{
\item{...}{Attributes, components, and/or child elements}

\item{primitive}{Primitive name (excluding the "a-")}
}
\description{
Functions to output A-Frame's custom HTML elements
}
\details{
These functions are just simple wrappers for
\code{\link[htmltools]{tag}} to output common A-Frame custom elements.
}
\section{Functions}{
\itemize{
\item \code{aframeScene}: Top level scene entity

\item \code{aframeAssets}: Specify assets for pre-loading

\item \code{aframeMixin}: Reusable component specifications

\item \code{aframeEntity}: Generic entity

\item \code{aframeSphere}: Sphere primitive

\item \code{aframeBox}: Box primitive

\item \code{aframePrimitive}: All other primitives
}}
\examples{
# Construct A-Frame HTML syntax for a 3D scene with a red box and blue sky
atags$scene(
  atags$box(color = "red", position = "0 0.5 -3"),
  atags$other("sky", color = "#89b6ff")
)

}
\seealso{
\href{https://aframe.io}{A-Frame Documentation}
}
\keyword{datasets}

