% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{dashboardLabel}
\alias{dashboardLabel}
\title{AdminLTE2 label}
\usage{
dashboardLabel(..., status, style = "default")
}
\arguments{
\item{...}{any text.}

\item{status}{label status. Valid statuses are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#3c8dbc")}
  \item \code{success}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#00a65a")}
  \item \code{info}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#00c0ef")}
  \item \code{warning}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#f39c12")}
  \item \code{danger}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#f56954")}
}}

\item{style}{label border style: "default" (rounded angles), "circle" or "square".}
}
\description{
Create a label
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)

  shinyApp(
    ui = dashboardPage(
      dashboardHeader(),
      dashboardSidebar(),
      dashboardBody(
        dashboardLabel("Label 1", status = "info"),
        dashboardLabel("Label 2", status = "danger", style = "circle"),
        dashboardLabel("Label 3", status = "success", style = "square")
      )
    ),
    server = function(input, output) { }
  )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
