% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyfilter.r
\name{event}
\alias{event}
\title{Get JavaScript code for filters' selectizeInput onchange event}
\usage{
event(name)
}
\arguments{
\item{name}{Name of the event/input variable set by the \code{selectizeInput}
filters whenever the selection changes. Can be handled in a call of
\code{observeEvent()}.}
}
\value{
JavaScript code for the \code{onChange} event.
}
\description{
Helper function to create the JavaScript event handler code for
  the \code{selectizeInput} filters of a shiny app using \code{shinyfilters}.
}
\details{
Processing the \code{onChange} event of the \code{selectizeInput}
  widgets that serve as the filters is necessary so that filters all the
  other \code{shinyfilter} filters bound to the same \code{reactable} can be
  updated accordingly and show the currently available filter options. All
  \code{selectizeInput} should have exactly the same event handler.

  You can of course create the JavaScript code for the \code{onChange} event
  handler function yourself, especially if you want to trigger additional
  operations in JavaScript whenever an \code{onChange} event occurs.
  \code{event()} function is just intended as a shortcut to save time and
  effort.

  For a full example of a shiny app using \code{shinyfilter} please call up
  the help for \code{\link{update_filters}()}. See the \code{README.md} file
  or the GitHub repo on
  \href{https://github.com/jsugarelli/shinyfilter}{https://github.com/jsugarelli/shinyfilter}
  for a comprehensive \code{shinyfilter} tutorial.
}
\examples{
event("myEvent")

}
