% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_install.R
\name{font_install}
\alias{font_install}
\alias{font_installed}
\title{Install Fonts to the 'showtextdb' Package}
\usage{
font_install(font_desc, quiet = FALSE, ...)

font_installed()
}
\arguments{
\item{font_desc}{A list that provides necessary information of the font
for installation. See the \strong{Details} section.}

\item{quiet}{Whether to show the progress of downloading and installation.}

\item{\dots}{Other parameters passed to \code{curl::curl_download()}.}
}
\description{
\code{font_install()} saves the specified font to the \file{fonts} directory of
the \pkg{showtextdb} package, so that it can be used by the \pkg{showtext}
package. This function requires the \pkg{curl} package.

\code{font_installed()} lists fonts that have been installed to
\pkg{showtextdb}.

\strong{NOTE}: Since the fonts are installed locally to the package directory,
they will be removed every time the \pkg{showtextdb} package is upgraded or
re-installed.
}
\details{
\code{font_desc} is a list that should contain at least the following components:

\describe{
  \item{\code{showtext_name}}{The family name of the font that will be used in
                              \pkg{showtext}.}
  \item{\code{font_ext}}{Extension name of the font files, e.g., \code{ttf} for
                         TrueType, and \code{otf} for OpenType.}
  \item{\code{regular_url}}{URL of the font file for "regular" font face.}
}

Optionally, \code{font_desc} can also contain \code{bold_url}, \code{italic_url},
\code{bolditalic_url}, and \code{symbol_url} that provide the URLs of the other
font faces.

See \code{\link{source_han_sans}()} and \code{\link{source_han_serif}()}
for an example of the \code{font_desc} parameter.
}
\examples{
\dontrun{
## Install Source Han Serif Simplified Chinese
font_install(source_han_serif())

## List available font families
sysfonts::font_families()

## Use the font with the "showtext" package
if(require(showtext)) {
    wd = setwd(tempdir())
    showtext.auto()
    
    pdf("source-han-serif.pdf")
    par(family = "source-han-serif-cn")
    plot.new()
    box()
    text(0.5, 0.9, "\u601d\u6e90\u5b8b\u4f53", cex = 3, font = 2)
    text(0.5, 0.4, "\u843d\u5176\u5b9e\u8005\u601d\u5176\u6811", cex = 3)
    text(0.5, 0.2, "\u996e\u5176\u6d41\u8005\u6000\u5176\u6e90", cex = 3)
    dev.off()
    setwd(wd)
}
}
}
\author{
Yixuan Qiu <\url{https://statr.me/}>
}
