% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shutterplot.R
\name{shutterplot}
\alias{shutterplot}
\title{Shutter Plot}
\usage{
shutterplot(
  x,
  y,
  main = "Shutter Plot",
  regbound = TRUE,
  wspace = 0.1,
  alpha = 0.05,
  locationOfnStar = 1,
  nprint = TRUE,
  colOfPoints = "grey68",
  xlab = "x",
  ylab = "y",
  regOutliers = TRUE,
  pch = 20,
  cex = 0.7,
  las = 1
)
}
\arguments{
\item{x}{data for the explanatory/independent variable.}

\item{y}{data for the response/dependent variable.}

\item{main}{the title for the shutter plot.}

\item{regbound}{logical: TRUE (Default), if you want the prediction boundaries;
FALSE, otherwise.}

\item{wspace}{white space to the left and the right of the plot.
The default is 0.1 (10 percent of the range of x).}

\item{alpha}{level of significance for prediction boundaries.
The default value is 0.05 (97.5 percentile of a T-distribution with df = n-2.}

\item{locationOfnStar}{binary: -1 for left; 1 (Default) for right.}

\item{nprint}{logical: TRUE (Default), to print the sample size; FALSE, otherwise.}

\item{colOfPoints}{The default is "grey68". Choose any color.}

\item{xlab}{name of the x variable.}

\item{ylab}{name of the y variable.}

\item{regOutliers}{logical: TRUE (Default), to circle the regression outliers; FALSE, to skip.}

\item{pch}{Either an integer specifying a symbol or a single character to be used as the default in plotting points.
See points for possible values and their interpretation. Note that only integers and single-character strings can be set as a graphics parameter (and not NA nor NULL).
The default value is 20.}

\item{cex}{A numerical value giving the amount by which plotting text and symbols should be magnified relative to the default 0.7.}

\item{las}{numeric in {0,1,2,3}; the style of axis labels.'
0: always parallel to the axis [default],
1:always horizontal,
2:always perpendicular to the axis,
3:always vertical.}
}
\value{
Draws the shutter plot.
}
\description{
This function depicts the elements of a simple linear regression model.
}
\examples{
  data1<- rnorm(90,10,10)
  data2<- data1+rnorm(90,20,10)
  shutterplot(data1,data2,regbound = TRUE,
     wspace = 0.1, alpha = 0.05,
     locationOfnStar = 1, nprint = TRUE, colOfPoints ="grey68",
      xlab = "data1", ylab = "data2", regOutliers = TRUE)
  shutterplot(data1,100-data2)
}
