% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doublesigmoidalFitFunctions_h0.R
\name{doublesigmoidalFitFormula_h0}
\alias{doublesigmoidalFitFormula_h0}
\title{Double Sigmoidal Formula with h0}
\usage{
doublesigmoidalFitFormula_h0(
  x,
  finalAsymptoteIntensityRatio,
  maximum,
  slope1Param,
  midPoint1Param,
  slope2Param,
  midPointDistanceParam,
  h0
)
}
\arguments{
\item{x}{the "time" column of the dataframe}

\item{finalAsymptoteIntensityRatio}{this is the ratio between the final asymptote intensity and maximum intensity of the fitted curve.}

\item{maximum}{the maximum intensity that the double sigmoidal function reaches.}

\item{slope1Param}{the slope parameter of the sigmoidal function at the steepest point in the exponential phase of the viral production.}

\item{midPoint1Param}{the x axis value of the steepest point in the function.}

\item{slope2Param}{the slope parameter of the sigmoidal function at the steepest point in the lysis phase. i.e when the intensity is decreasing.}

\item{midPointDistanceParam}{the distance between the time of steepest increase and steepest decrease in the intensity data. In other words the distance between the x axis values of arguments of slope1Param and slope2Param.}

\item{h0}{the lower asymptote (baseline) intensity}
}
\value{
Returns the predicted intensities for the given time points with the double sigmoidal fitted parameters for the double sigmoidal fit.
}
\description{
Calculates intensities using the double sigmoidal model fit and the parameters (maximum, final asymptote intensity, slope1Param, midpoint1Param, slope2Param, and midpoint distance).
}
\examples{
# runif() is used here for consistency with previous versions of the sicegar package. However,
# rnorm() will generate symmetric errors, producing less biased numerical parameter estimates.
# We recommend errors generated with rnorm() for any simulation studies on sicegar.
time <- seq(3, 24, 0.1)

#simulate intensity data and add noise
noise_parameter <- 0.2
intensity_noise <- stats::runif(n = length(time), min = 0, max = 1) * noise_parameter
intensity <- doublesigmoidalFitFormula_h0(time,
                                      finalAsymptoteIntensityRatio = .3,
                                      maximum = 4,
                                      slope1Param = 1,
                                      midPoint1Param = 7,
                                      slope2Param = 1,
                                      midPointDistanceParam = 8,
                                      h0 = 1)
intensity <- intensity + intensity_noise

dataInput <- data.frame(intensity = intensity, time = time)
normalizedInput <- normalizeData(dataInput)
parameterVector <- doublesigmoidalFitFunction_h0(normalizedInput, tryCounter = 1)


#Check the results
# doublesigmoidalFitFunction_h0() is run on the startList param values (because 'tryCounter = 1')
# use multipleFitFunction() for multiple random starts in order to optimize
if(parameterVector$isThisaFit){
 intensityTheoretical <-
       doublesigmoidalFitFormula_h0(
               time,
               finalAsymptoteIntensityRatio = parameterVector$finalAsymptoteIntensityRatio_Estimate,
               maximum = parameterVector$maximum_Estimate,
               slope1Param = parameterVector$slope1Param_Estimate,
               midPoint1Param = parameterVector$midPoint1Param_Estimate,
               slope2Param = parameterVector$slope2Param_Estimate,
               midPointDistanceParam = parameterVector$midPointDistanceParam_Estimate,
               h0 = parameterVector$h0_Estimate)

 comparisonData <- cbind(dataInput, intensityTheoretical)

 require(ggplot2)
 ggplot(comparisonData) +
   geom_point(aes(x = time, y = intensity)) +
   geom_line(aes(x = time, y = intensityTheoretical)) +
   expand_limits(x = 0, y = 0)
   }

if(!parameterVector$isThisaFit){
  print(parameterVector)
  }


}
