% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{sg_layout}
\alias{sg_layout}
\alias{sg_get_layout}
\title{Layouts}
\usage{
sg_layout(
  sg,
  directed = TRUE,
  layout = igraph::layout_nicely,
  save_igraph = TRUE,
  ...
)

sg_get_layout(
  nodes,
  edges,
  directed = TRUE,
  layout = igraph::layout_nicely,
  save_igraph = TRUE,
  ...
)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{directed}{Whether or not to create a directed graph, passed to \code{\link[igraph]{graph_from_data_frame}}.}

\item{layout}{An \code{igraph} layout function.}

\item{save_igraph}{Whether to save the \code{igraph} object used internally.}

\item{...}{Any other parameter to pass to \code{layout} function.}

\item{nodes, edges}{Nodes and edges as prepared for sigmajs.}
}
\value{
\code{sg_get_layout} returns nodes with \code{x} and \code{y} coordinates.
}
\description{
Layout your graph.
}
\details{
The package uses \code{igraph} internally for a lot of computations the \code{save_igraph} 
allows saving the object to speed up subsequent computations.
}
\section{Functions}{

\itemize{
  \item{\code{sg_layout} layout your graph.}
  \item{\code{sg_get_layout} helper to get graph's \code{x} and \code{y} positions.}
}
}

\examples{
nodes <- sg_make_nodes(250) # 250 nodes
edges <- sg_make_edges(nodes, n = 500)

sigmajs() \%>\% 
  sg_nodes(nodes, id, size, color) \%>\% 
  sg_edges(edges, id, source, target) \%>\% 
  sg_layout()

nodes_coords <- sg_get_layout(nodes, edges)

}
