% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_soil.R
\name{cal_capillaryRise}
\alias{cal_capillaryRise}
\title{Calculating capillary rise}
\usage{
cal_capillaryRise(
  a1,
  b1 = -0.17,
  a2,
  b2 = -0.27,
  a3 = -1.3,
  b3,
  a4,
  b4,
  Dw,
  Wa,
  LAI,
  ETm
)
}
\arguments{
\item{a1}{Soil water storage to maximum root depth at field capacity(mm).}

\item{b1}{A parameter.}

\item{a2}{storage above the average between those at field capacity and the wilting point(mm).}

\item{b2}{A parameter.}

\item{a3}{A parameter.}

\item{b3}{A parameter.6.7 for clay and silty clay loam soils, decreasing to 6.2 for loamy sands}

\item{a4}{A parameter.4.6 for silty loam and silty clay loam soils,decreasing to 6.2 for loamy sands.}

\item{b4}{A parameter.-0.65 for silty loam soils and decreasing to -2.5 for loamy sand soils.}

\item{Dw}{Groudwater depth below root zone(m).}

\item{Wa}{actual soil water storage in the root zone.}

\item{LAI}{Leaf area index.}

\item{ETm}{potential crop evaporanspiration (mm/day),usually ETm=ETc(mm/d).}
}
\value{
The value for capillary Rise (mm/day).
}
\description{
Calculating capillary rise
}
\references{
Liu Y, Pereira L S, Fernando R M. Fluxes through the bottom boundary of the root zone in silty soils:
 Parametric approaches to estimate groundwater contribution and percolation[J].
 Agricultural Water Management, 2006, 84(1):27-40.
}
