% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep_plot.R
\name{plot_visit_med75}
\alias{plot_visit_med75}
\title{Plot patient visits against visit_med75.}
\usage{
plot_visit_med75(
  df_visit,
  df_site = NULL,
  study_id_str,
  n_sites = 6,
  min_pat_pool = 0.2,
  verbose = TRUE,
  event_names = "ae",
  plot_event = "ae",
  ...
)
}
\arguments{
\item{df_visit}{dataframe}

\item{df_site}{dataframe, as returned by \code{\link[=site_aggr]{site_aggr()}}}

\item{study_id_str}{character, specify study in study_id column}

\item{n_sites}{integer, Default: 6}

\item{min_pat_pool}{double, minimum ratio of available patients available for
sampling. Determines maximum visit_med75 value see Details. Default: 0.2}

\item{verbose}{logical, Default: TRUE}

\item{event_names}{vector, contains the event names, default = "ae"}

\item{plot_event}{vector containing the events that should be plotted, default = "ae"}

\item{...}{not used}
}
\value{
ggplot
}
\description{
Plots cumulative AEs against visits for patients at sites of
given study and compares against visit_med75.
}
\examples{
df_visit <- sim_test_data_study(
  n_pat = 120,
  n_sites = 6,
  ratio_out = 0.4,
  factor_event_rate = - 0.6
 ) \%>\%
 dplyr::rename(
  site_number = site_id,
  patnum = patient_id,
  n_ae = n_event
 )

df_site <- site_aggr(df_visit)

simaerep:::plot_visit_med75(df_visit, df_site, study_id_str = "A", n_site = 6)
}
\keyword{internal}
