% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recomb_map_inds.R
\name{recomb_map_inds}
\alias{recomb_map_inds}
\title{Map recombination breaks from genetic positions to base pair coordinates}
\usage{
recomb_map_inds(inds, map)
}
\arguments{
\item{inds}{The list of individuals, each of which is a list with two haploid individuals named \code{pat} and \code{mat}, each of which is a list of chromosomes (always identified by number, but may also be named arbitrarily), each of which is a data.frame/tibble with implicit ranges (\code{posg} is end coordinates in cM; start is the end of the previous block, zero for the first block) and ancestors \code{anc} as strings.}

\item{map}{The genetic map, a list of chromosomes each of which is a data.frame/tibble with columns \code{pos} for base pair position and \code{posg} for genetic position.}
}
\value{
The input list of individuals, with each chromosome added column \code{pos} corresponding to end coordinate in base pairs.
Each chromosome has columns reordered so \code{pos}, \code{posg}, and \code{anc} appear first, and any additional columns appear afterwards.
}
\description{
Given a list of individuals with recombination breaks given in genetic distance (such as the output of \code{\link[=recomb_fam]{recomb_fam()}}), and a genetic map (see \code{\link{recomb_map_hg}}), this function determines all positions in base pair coordinates.
If base pair positions existed in input, they are overwritten.
}
\details{
Genetic positions are converted to base pair positions from the provided map using linear interpolation, using \code{\link[stats:approxfun]{stats::approx()}} with options \code{rule = 2} (out of range cases are set to nearest end's value) and \code{ties = list( 'ordered', mean )} (assume data is ordered, interpolate ties in genetic distance in map using mean of base pair positions).
Output will be incorrect, without throwing errors, if genetic map is not ordered.
Base pair positions are rounded to integers.
}
\examples{
# Lengthy code creates individuals with recombination data to map
# The smallest pedigree, two parents and a child (minimal fam table).
library(tibble)
fam <- tibble(
  id = c('father', 'mother', 'child'),
  pat = c(NA, NA, 'father'),
  mat = c(NA, NA, 'mother')
)
# use latest human recombination map, but just first two chrs to keep this example fast
map <- recomb_map_hg38[ 1:2 ]
# initialize parents with this other function
founders <- recomb_init_founders( c('father', 'mother'), map )
# draw recombination breaks for child
inds <- recomb_fam( founders, fam )

# now use this function to add base pair coordinates for recombination breaks!
inds <- recomb_map_inds( inds, map )

}
\seealso{
\code{\link[=recomb_fam]{recomb_fam()}} for drawing recombination breaks of individuals from a pedigree.

\code{\link{recomb_map_hg}} for simplified human recombination maps included in this package.
}
