% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{analyze.simstudy.chisq.test.ind}
\alias{analyze.simstudy.chisq.test.ind}
\title{analyze.simstudy.chisq.test.ind}
\usage{
analyze.simstudy.chisq.test.ind(
  test.statistics.chisq.test.ind,
  conf.level = 0.95,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975)
)
}
\arguments{
\item{test.statistics.chisq.test.ind}{A list containing summary information
for fitting chi squared tests of independence. The structure is in the form
returned by the function \code{simitation::sim.chisq.test.ind()}.}

\item{conf.level}{A numeric value between 0 and 1 representing the confidence
level (1 - significance level). Default is 0.95.}

\item{the.quantiles}{A numeric vector of values between 0 and 1. Summary
statistics to analyze the tests will return the specified quantiles. Default
values are c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975).}
}
\value{
A list containing the following elements:
\itemize{
  \item stat.summary: Summary statistics for the test statistics.
  \item p.value.summary: Proportions of tests that rejected and did not
  reject the null hypothesis.
}
}
\description{
This function analyzes the results of a simulated chi-squared
test of independence.
}
\examples{

n <- c(50, 75, 100)
values <- LETTERS[1:4]
group.names <- paste0("group_", 1:3)
probs <- matrix(data = c(0.25, 0.25, 0.25, 0.25, 0.4, 0.3, 0.2,
0.1, 0.2, 0.4, 0.2, 0.2), nrow = length(n), byrow = TRUE)

simdat.chisq.ind <- sim.chisq.ind(n = c(50, 75, 100),
values = LETTERS[1:4], probs = probs, num.experiments = 2,
experiment.name = "exp_id", group.name = "treatment_group",
group.values = paste0("group_", 1:3), value.name = "category", seed = 31)
test.statistics.chisq.test.ind <- sim.chisq.test.ind(simdat.chisq.ind =
simdat.chisq.ind, correct = TRUE, experiment.name = "exp_id", group.name =
 "treatment_group", value.name = "category")


analysis.chisq.ind <- analyze.simstudy.chisq.test.ind(
test.statistics.chisq.test.ind = test.statistics.chisq.test.ind, conf.level =
 0.95, the.quantiles = c(0.025, 0.975))
}
