% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-functions.R
\name{plot_simrel}
\alias{plot_simrel}
\title{A wrapper function for a simrel object}
\usage{
plot_simrel(
  obj,
  ncomp = min(obj$p, obj$n, 20),
  which = c(1L:4L),
  layout = NULL,
  print.cov = FALSE,
  use_population = TRUE,
  palette = "Set1",
  base_theme = ggplot2::theme_grey,
  lab_list = NULL,
  theme_list = NULL
)
}
\arguments{
\item{obj}{A simrel object}

\item{ncomp}{Number of components to show in x-axis}

\item{which}{An integer specifying which simrel plot to obtain}

\item{layout}{A layout matrix for arranging the simrel plots}

\item{print.cov}{A boolean where to print covariance matrices}

\item{use_population}{A boolean specifying weather to get plot for population or sample}

\item{palette}{Name of color paletter compaticable with RColorBrewer}

\item{base_theme}{Base ggplot theme to apply}

\item{lab_list}{List of labs arguments such as x, y, title, subtitle. A nested list if the argument which has length greater than 1.}

\item{theme_list}{List of theme arguments to apply in the plot. A nested list if the argument which has length greater than 1.}
}
\value{
Simrel Plot(s)
}
\description{
A wrapper function for a simrel object
}
\examples{
sobj <- bisimrel(p = 12)
plot_simrel(sobj, layout = matrix(1:4, 2, 2))
}
