% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmwm.r
\name{update.gmwm}
\alias{update.gmwm}
\title{Update (Robust) GMWM object for IMU or SSM}
\usage{
\method{update}{gmwm}(object, model, ...)
}
\arguments{
\item{object}{A \code{gmwm} object.}

\item{model}{A \code{ts.model} object containing one of the allowed models}

\item{...}{Additional parameters (not used)}
}
\value{
A \code{gmwm} object with the structure:
 \item{estimate}{Estimated Parameters Values from the GMWM Procedure}
 \item{init.guess}{Initial Starting Values given to the Optimization Algorithm}
 \item{wv.empir}{The data's empirical wavelet variance}
 \item{ci_low}{Lower Confidence Interval}
 \item{ci_high}{Upper Confidence Interval}
 \item{orgV}{Original V matrix}
 \item{V}{Updated V matrix (if bootstrapped)}
 \item{omega}{The V matrix inversed}
 \item{obj.fun}{Value of the objective function at Estimated Parameter Values}
 \item{theo}{Summed Theoretical Wavelet Variance}
 \item{decomp.theo}{Decomposed Theoretical Wavelet Variance by Process}
 \item{scales}{Scales of the GMWM Object}
 \item{robust}{Indicates if parameter estimation was done under robust or classical}
 \item{eff}{Level of efficiency of robust estimation}
 \item{model.type}{Models being guessed}
 \item{compute.v}{Type of V matrix computation}
 \item{augmented}{Indicates moments have been augmented}
 \item{alpha}{Alpha level used to generate confidence intervals}
 \item{expect.diff}{Mean of the First Difference of the Signal}
 \item{N}{Length of the Signal}
 \item{G}{Number of Guesses Performed}
 \item{H}{Number of Bootstrap replications}
 \item{K}{Number of V matrix bootstraps}
 \item{model}{\code{ts.model} supplied to gmwm}
 \item{model.hat}{A new value of \code{ts.model} object supplied to gmwm}
 \item{starting}{Indicates whether the procedure used the initial guessing approach}
 \item{seed}{Randomization seed used to generate the guessing values}
 \item{freq}{Frequency of data}
}
\description{
Provides a way to estimate different models over the previously estimated
wavelet variance values and covariance matrix.
}
