% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tandem.R
\docType{class}
\name{attributes.tandem-class}
\alias{attributes.tandem-class}
\title{Tandem results attributes}
\description{
Tandem results attributes
}
\section{Slots}{

\describe{
\item{\code{U_i_g0}}{matrix. Initial object membership function matrix.}

\item{\code{B_j_q0}}{matrix. Initial factor/component matrix for the variables.}

\item{\code{C_k_r0}}{matrix. Initial factor/component matrix for the occasions.}

\item{\code{U_i_g}}{matrix. Final/updated object membership function matrix.}

\item{\code{B_j_q}}{matrix. Final/updated factor/component matrix for the variables.}

\item{\code{C_k_r}}{matrix. Final/updated factor/component matrix for the occasions.}

\item{\code{Y_g_qr}}{matrix. Derived centroids in the reduced space (data matrix).}

\item{\code{X_i_jk_scaled}}{matrix. Standardized dataset matrix.}

\item{\code{BestTimeElapsed}}{numeric. Execution time for the best iterate.}

\item{\code{BestLoop}}{numeric. Loop that obtained the best iterate.}

\item{\code{BestKmIteration}}{numeric. Number of iteration until best iterate for the K-means.}

\item{\code{BestFaIteration}}{numeric. Number of iteration until best iterate for the FA.}

\item{\code{FaConverged}}{numeric. Flag to check if algorithm converged for the K-means.}

\item{\code{KmConverged}}{numeric. Flag to check if algorithm converged for the Factor Decomposition.}

\item{\code{nKmConverges}}{numeric. Number of loops that converged for the K-means.}

\item{\code{nFaConverges}}{numeric. Number of loops that converged for the Factor decomposition.}

\item{\code{TSS_full}}{numeric. Total deviance in the full-space.}

\item{\code{BSS_full}}{numeric. Between deviance in the reduced-space.}

\item{\code{RSS_full}}{numeric. Residual deviance in the reduced-space.}

\item{\code{PF_full}}{numeric. PseudoF in the full-space.}

\item{\code{TSS_reduced}}{numeric. Total deviance in the reduced-space.}

\item{\code{BSS_reduced}}{numeric. Between deviance in the reduced-space.}

\item{\code{RSS_reduced}}{numeric. Residual deviance in the reduced-space.}

\item{\code{PF_reduced}}{numeric. PseudoF in the reduced-space.}

\item{\code{PF}}{numeric. Actual PseudoF value to obtain best loop.}

\item{\code{Labels}}{integer. Object cluster assignments.}

\item{\code{FsKM}}{numeric. Objective function values for the KM best iterate.}

\item{\code{FsFA}}{numeric. Objective function values for the FA best iterate.}

\item{\code{Enorm}}{numeric. Average l2 norm of the residual norm.}
}}

