% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_dataset.R
\name{generate_dataset}
\alias{generate_dataset}
\title{Three-Mode Dataset Generator for Simulations}
\usage{
generate_dataset(
  I = 8,
  J = 5,
  K = 4,
  G = 3,
  Q = 3,
  R = 2,
  centroids_spread = c(0, 1),
  noise_mean = 0,
  noise_stdev = 0.5,
  seed = NULL
)
}
\arguments{
\item{I}{Number of objects.}

\item{J}{Number of variables per occasion.}

\item{K}{Number of occasions.}

\item{G}{Number of clusters.}

\item{Q}{Number of factors for the variables.}

\item{R}{Number of factors for the occasions.}

\item{centroids_spread}{interval from which to uniformly pick the centroids.}

\item{noise_mean}{Mean of noise to generate.}

\item{noise_stdev}{Noise effect level/spread/standard deviation.}

\item{seed}{Seed for random sequence generation.}
}
\value{
Z_i_jk: Component scores in the full space.

E_i_jk: Generated noise at the given noise level.

X_i_jk: Dataset with noise level set to noise_stdev specified.

Y_g_qr: Centroids matrix in the reduced space.

U_i_g: Stochastic membership function matrix.

B_j_q: Objects component scores matrix.

C_k_r: Occasions component scores matrix.
}
\description{
Generate G clustered synthetic dataset of I objects measured on J variables
for K occasions with additive noise.
}
\examples{
generate_dataset(seed=0)

}
