% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-from-simulation.R
\name{draws}
\alias{draws}
\title{Get one or more draws from a simulation}
\usage{
draws(sim, ..., subset = NULL, index, reference = FALSE)
}
\arguments{
\item{sim}{a simulation object}

\item{...}{logical conditions to specify a subset of models.  Conditions can
only involve params of model that have length 1 and are of class
numeric or character.}

\item{subset}{a vector of integers indexing the models or a vector of model
names. To select models based on parameter values, use \code{...}.
However, using \code{...} is slower than using subset.}

\item{index}{a vector of positive integers specifying which draws objects
are desired. If missing, then all draws' outputs are returned.}

\item{reference}{whether to return the ModelRef or the Model object itself}
}
\description{
Returns either the draws objects themselves or references to them.  See
\code{\link{model}} function for more information on the \code{...} and
\code{subset} arguments, which are used to specify a subset of the models.
}
\examples{
\dontrun{
 # suppose previously we had run the following:
 sim <- new_simulation(name = "normal-example",
                       label = "Normal Mean Estimation",
                       dir = tempdir()) \%>\%
   generate_model(make_my_example_model, n = 20) \%>\%
   simulate_from_model(nsim = 50, index = 1:3)
 # then we could get the simulated draws as follows:
 d <- draws(sim)
 d@draws$r1.1 # first random draw
 }
}
