% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{load_evals}
\alias{load_evals}
\alias{load_evals_from_ref}
\title{Load one or more Evals objects from file.}
\usage{
load_evals(
  dir,
  model_name,
  index,
  method_names,
  metric_names = NULL,
  out_loc = "out",
  simulator.files = NULL
)

load_evals_from_ref(ref, metric_names = NULL)
}
\arguments{
\item{dir}{the directory passed to \code{\link{generate_model}})}

\item{model_name}{the \code{\linkS4class{Model}} object's \code{name}}

\item{index}{a vector of positive integers.}

\item{method_names}{the \code{name} of one or more \code{\linkS4class{Method}}
objects.}

\item{metric_names}{(optional) a character vector of which elements of
evals should be loaded. If NULL, then all elements are loaded.}

\item{out_loc}{only needed if it was used in call to}

\item{simulator.files}{if NULL, then \code{getOption("simulator.files")}
will be used.
\code{\link{run_method}}.}

\item{ref}{an object of class \code{\linkS4class{EvalsRef}}}
}
\description{
After \code{\link{evaluate}} has been called, this function can
be used to load one or more of the saved \code{\linkS4class{Evals}} object(s).
If multiple indices are provided, these will be combined by index into a
new single \code{\linkS4class{Evals}} object.  If multiple methods are provided,
a list of \code{\linkS4class{Evals}} objects will be returned.
}
\seealso{
\code{\link{load_model}} \code{\link{load_draws}}
         \code{\link{as.data.frame.Evals}}
}
