% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{simulate_from_model}
\alias{simulate_from_model}
\title{Simulate from a model.}
\usage{
simulate_from_model(object, nsim, index = 1, parallel = NULL)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{ModelRef}} as returned by
\code{link{generate_model}}. Or a list of such objects. If
\code{object} is a \code{Simulation}, then function is applied to the
referenced models in that simulation and returns the same
\code{Simulation} object but with references added to the new draws
created.}

\item{nsim}{number of simulations to be conducted.  If a scalar, then
value repeated for each index.  Otherwise can be a vector of length
\code{length(index)}}

\item{index}{a vector of positive integer indices.  Allows simulations to be
carried out in chunks.  Each chunk gets a separate RNG stream,
meaning that the results will be identical whether we run these in
parallel or sequentially.}

\item{parallel}{either \code{NULL} or a list containing \code{socket_names}
and (optionally) \code{libraries} and \code{save_locally}
(see Details for more information)}
}
\description{
Given a reference to a \code{\linkS4class{Model}} object, this function calls the
model's \code{simulate} function on its \code{params}.  It repeats this
\code{nsim} times.  For example, when simulating regression with a fixed
design, this function would generate \code{nsim} response vectors \code{y}.
}
\details{
This function creates objects of class \code{\linkS4class{Draws}} and saves each to
file (at dir/files/model_name/r<index>.Rdata). Note: while "files" is the
default, the name of this directory is from getOption("simulator.files"),
which is the value of getOption("simulator.files") when the model was
created.

If parallel is not NULL, then it must be a list containing
\code{socket_names}, which can either be a positive integer specifying the
number of copies to run on localhost or else a character vector of machine
names (e.g., "mycluster-0-0").  The list \code{parallel} can also contain
\code{libraries}, a character vector of R packages that will be needed on the
slaves and \code{save_locally}, a logical that indicates whether the files
generated should be saved on the slaves (i.e., locally) or on the master.
}
\examples{
\dontrun{
 sim <- new_simulation(name = "normal-example",
                       label = "Normal Mean Estimation",
                       dir = tempdir()) \%>\%
   generate_model(make_my_example_model, n = 20) \%>\%
   simulate_from_model(nsim = 50, index = 1:3,
     parallel = list(socket_names = 3))
 }
}
\seealso{
\code{\link{load_draws}} \code{\link{generate_model}} \code{\link{run_method}}
}
