% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeImport.R
\name{make_import}
\alias{make_import}
\title{Populate import fields for documentation}
\usage{
make_import(
  script,
  cut = NULL,
  print = TRUE,
  format = "oxygen",
  desc_loc = NULL
)
}
\arguments{
\item{script}{character, connection to pass to readLines, can be file path,
directory path, url path}

\item{cut}{integer, number of functions to write as importFrom until
switches to import, Default: NULL}

\item{print}{boolean, print output to console, Default: TRUE}

\item{format}{character, the output format must be in
c('oxygen','description','import'), Default: 'oxygen'}

\item{desc_loc}{character, path to DESCRIPTION file,
if not NULL then the Imports fields in the DESCRIPTION file, Default: NULL}
}
\description{
Scrape \code{R} script to create import and importFrom calls for
roxygen2, namespace or description files
}
\examples{

# copy dummy package to tempdir
file.copy(system.file('pkg',package = 'sinew'),tempdir(),recursive = TRUE)

pkg_dir <- file.path(tempdir(),'pkg')
pkg_dir_R <- file.path(pkg_dir,'R')
pkg_dir_DESC <- file.path(pkg_dir,'DESCRIPTION')

# update namespaces in package functions
pretty_namespace(pkg_dir_R, overwrite = TRUE)

# update imports/importsFrom for roxygen2 tags
make_import(pkg_dir_R,format = 'oxygen')

# update Imports for DESCRIPTION file output to console
make_import(pkg_dir_R,format = 'description')

# update Imports for DESCRIPTION file overwrite file
make_import(pkg_dir_R,format = 'description', desc_loc = pkg_dir)

cat(readLines(pkg_dir_DESC),sep = '\n')

# cleanup tempdir
unlink(pkg_dir, force = TRUE, recursive = TRUE)

}
\concept{populate}
