% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policies.R
\name{aws_policy_detach}
\alias{aws_policy_detach}
\title{Detach a policy from a user, group, or role}
\usage{
aws_policy_detach(.x, policy)
}
\arguments{
\item{.x}{result of a call to create or get method for user,
group, or role}

\item{policy}{(character) a policy name or ARN}
}
\value{
A tibble with information about policies
}
\description{
Detach a policy from a user, group, or role
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (aws_user_exists("user456")) {
  aws_user_delete("user456")
}

aws_user_create("user456")
aws_user("user456") \%>\% aws_policy_attach("AmazonRDSDataFullAccess")
aws_user("user456") \%>\% aws_policy_detach("AmazonRDSDataFullAccess")
aws_user("user456")$attached_policies
# cleanup
six_user_delete("user456")
\dontshow{\}) # examplesIf}
}
\seealso{
Other policies: 
\code{\link{as_policy_arn}()},
\code{\link{aws_policies}()},
\code{\link{aws_policy}()},
\code{\link{aws_policy_attach}()},
\code{\link{aws_policy_create}()},
\code{\link{aws_policy_delete}()},
\code{\link{aws_policy_delete_version}()},
\code{\link{aws_policy_exists}()},
\code{\link{aws_policy_list_entities}()},
\code{\link{aws_policy_list_versions}()},
\code{\link{aws_policy_update}()}
}
\concept{policies}
