% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policies.R
\name{aws_policy_exists}
\alias{aws_policy_exists}
\title{Check if a policy exists}
\usage{
aws_policy_exists(name)
}
\arguments{
\item{name}{(character) a policy name or arn}
}
\value{
single logical, \code{TRUE} or \code{FALSE}
}
\description{
Checks for both customer managed and AWS managed policies
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# just the policy name
aws_policy_exists("ReadOnlyAccess")
# as an ARN
aws_policy_exists("arn:aws:iam::aws:policy/ReadOnlyAccess")
# includes job-function in path
aws_policy_exists("Billing")
# includes service-role in path
aws_policy_exists("AWSCostAndUsageReportAutomationPolicy")
\dontshow{\}) # examplesIf}
}
\seealso{
Other policies: 
\code{\link{as_policy_arn}()},
\code{\link{aws_policies}()},
\code{\link{aws_policy}()},
\code{\link{aws_policy_attach}()},
\code{\link{aws_policy_create}()},
\code{\link{aws_policy_delete}()},
\code{\link{aws_policy_delete_version}()},
\code{\link{aws_policy_detach}()},
\code{\link{aws_policy_list_entities}()},
\code{\link{aws_policy_list_versions}()},
\code{\link{aws_policy_update}()}
}
\concept{policies}
